# Clause 51 BBI allocations: NZGP 1.1 CNI Allocation Tiwai Stays re-run

*Generated: 2026-01-27 14:10:47.190688, sddp2tpm version: 1.17.0,
 User: davisc*

[TOC]

## Allocations

<div class="container" style="max-width: 1000px;">
<div class="row">
<div class="col-md-4">
<h3>Customer allocations</h3>
<p><i>Output file: allocations.csv</i></p>
<div class="table-responsive" style="max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>Allocation (%)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>Vector Ltd</th>
      <td>26.62%</td>
    </tr>
    <tr>
      <th>Meridian Energy Ltd</th>
      <td>26.57%</td>
    </tr>
    <tr>
      <th>Contact Energy Ltd</th>
      <td>8.55%</td>
    </tr>
    <tr>
      <th>Powerco Ltd</th>
      <td>7.64%</td>
    </tr>
    <tr>
      <th>Unison Networks Ltd</th>
      <td>4.07%</td>
    </tr>
    <tr>
      <th>WEL Networks Ltd</th>
      <td>3.69%</td>
    </tr>
    <tr>
      <th>Northpower Ltd</th>
      <td>2.46%</td>
    </tr>
    <tr>
      <th>Genesis Energy Ltd</th>
      <td>2.31%</td>
    </tr>
    <tr>
      <th>Mercury SPV Ltd</th>
      <td>1.99%</td>
    </tr>
    <tr>
      <th>Counties Power Ltd</th>
      <td>1.89%</td>
    </tr>
    <tr>
      <th>MEL (West Wind) Ltd</th>
      <td>1.78%</td>
    </tr>
    <tr>
      <th>Waverly Wind Farm Ltd</th>
      <td>1.57%</td>
    </tr>
    <tr>
      <th>Tararua Wind Power</th>
      <td>1.45%</td>
    </tr>
    <tr>
      <th>New Zealand Steel Ltd</th>
      <td>1.39%</td>
    </tr>
    <tr>
      <th>Waipa Networks Ltd</th>
      <td>1.30%</td>
    </tr>
    <tr>
      <th>Manawa Energy Ltd</th>
      <td>1.12%</td>
    </tr>
    <tr>
      <th>Pan Pac Forest Product Ltd</th>
      <td>1.06%</td>
    </tr>
    <tr>
      <th>Eastland Network Ltd</th>
      <td>0.90%</td>
    </tr>
    <tr>
      <th>MEL (Te Apiti) Ltd</th>
      <td>0.90%</td>
    </tr>
    <tr>
      <th>The Lines Company Ltd</th>
      <td>0.76%</td>
    </tr>
    <tr>
      <th>Winstone Pulp International</th>
      <td>0.68%</td>
    </tr>
    <tr>
      <th>Horizon Energy Distribution Ltd</th>
      <td>0.46%</td>
    </tr>
    <tr>
      <th>Whareroa Cogeneration Ltd</th>
      <td>0.43%</td>
    </tr>
    <tr>
      <th>KiwiRail Holdings Ltd</th>
      <td>0.11%</td>
    </tr>
    <tr>
      <th>Aurora Energy Ltd</th>
      <td>0.11%</td>
    </tr>
    <tr>
      <th>Westpower Ltd</th>
      <td>0.08%</td>
    </tr>
    <tr>
      <th>Nova Energy Ltd</th>
      <td>0.05%</td>
    </tr>
    <tr>
      <th>Alpine Energy Ltd</th>
      <td>0.04%</td>
    </tr>
    <tr>
      <th>Wellington Electricity Lines Ltd</th>
      <td>0.01%</td>
    </tr>
    <tr>
      <th>Southpark Utilities Ltd</th>
      <td>0.00%</td>
    </tr>
  </tbody>
</table>
</div>
</div>
<div class="col-md-4">
<h3>Regional customer group allocations</h3>
<p><i>Output file: final_group_alloc.csv</i></p>
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>Allocation (%)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>UNI_Non-industrial</th>
      <td>53.05%</td>
    </tr>
    <tr>
      <th>SI_storage</th>
      <td>38.29%</td>
    </tr>
    <tr>
      <th>LNI_wind</th>
      <td>7.69%</td>
    </tr>
    <tr>
      <th>LNI_cogen</th>
      <td>0.43%</td>
    </tr>
    <tr>
      <th>LNI_run of river</th>
      <td>0.22%</td>
    </tr>
    <tr>
      <th>LNI_gen_with_load</th>
      <td>0.17%</td>
    </tr>
    <tr>
      <th>SI_run of river</th>
      <td>0.12%</td>
    </tr>
    <tr>
      <th>LNI_peaker</th>
      <td>0.04%</td>
    </tr>
  </tbody>
</table>
</div>
<div class="col-md-4">
<h3>Regional demand and supply allocations</h3>
<p><i>Output file: region_supply_demand_alloc.csv</i></p>
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th>Allocation (%)</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>UNI</th>
      <th>demand</th>
      <td>53.05%</td>
    </tr>
    <tr>
      <th>SI</th>
      <th>supply</th>
      <td>38.41%</td>
    </tr>
    <tr>
      <th>LNI</th>
      <th>supply</th>
      <td>8.54%</td>
    </tr>
    <tr>
      <th>UNI</th>
      <th>supply</th>
      <td>0.00%</td>
    </tr>
  </tbody>
</table>
</div>
</div>
</div>
<br>

----

## Working tables

### Wind repowering adjustments for generator PVEMBD

According to the TPM[^step_loads], benefits due to large steps in future generation 
should not be included when determining starting allocations.  Plants not already 
committed are already excluded in the input `plants.csv`. However, 
several existing wind farms are assumed to undergo repowering at set times
in the future.  While it is reasonable to include future benefits due to the *current*
capacity of these plants, we should not include *future* increases to capacity of
these wind farms.

In SDDP wind farm repowering is handled by replacing the existing wind farm with a
new plant with increased capacity.  To exclude benefits do to increases in capacity, 
generator PVEMBD for repowered plants is multiplied by the ratio of the original 
capacity to the repowered capacity.

*Output file: repower_adj.csv*

<div class="container" style="max-width: 800px;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th>Capacity_MW</th>
      <th>Replaces</th>
      <th>orig_cap</th>
      <th>adj_factor</th>
    </tr>
    <tr>
      <th>plant</th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>MillCrk_Rpwr</th>
      <td>105.0</td>
      <td>MillCreek</td>
      <td>60.00</td>
      <td>0.571429</td>
    </tr>
    <tr>
      <th>TaraW1_Rpwr</th>
      <td>100.8</td>
      <td>TaraW1</td>
      <td>34.32</td>
      <td>0.340476</td>
    </tr>
    <tr>
      <th>TaraW2_Rpwr</th>
      <td>140.0</td>
      <td>TaraW2</td>
      <td>33.66</td>
      <td>0.240429</td>
    </tr>
    <tr>
      <th>TaraW3_Rpwr</th>
      <td>125.0</td>
      <td>TaraWd3</td>
      <td>93.00</td>
      <td>0.744000</td>
    </tr>
    <tr>
      <th>TeApiti_Rpwr</th>
      <td>220.0</td>
      <td>TeApiti</td>
      <td>90.80</td>
      <td>0.412727</td>
    </tr>
    <tr>
      <th>TRrHau_Rpwr</th>
      <td>82.0</td>
      <td>TeRereHau</td>
      <td>16.50</td>
      <td>0.201220</td>
    </tr>
    <tr>
      <th>TRrHau3_Rpwr</th>
      <td>82.0</td>
      <td>TeRereHau3</td>
      <td>16.00</td>
      <td>0.195122</td>
    </tr>
    <tr>
      <th>TRrHau4_Rpwr</th>
      <td>81.0</td>
      <td>TeRereHau4</td>
      <td>16.00</td>
      <td>0.197531</td>
    </tr>
    <tr>
      <th>TeUku_Rpwr</th>
      <td>110.0</td>
      <td>TeUku</td>
      <td>64.40</td>
      <td>0.585455</td>
    </tr>
    <tr>
      <th>WstWnd_Rpwr</th>
      <td>250.0</td>
      <td>WestWind</td>
      <td>142.60</td>
      <td>0.570400</td>
    </tr>
    <tr>
      <th>Mahiner_Rpwr</th>
      <td>50.0</td>
      <td>Mahiner_s1</td>
      <td>36.00</td>
      <td>0.720000</td>
    </tr>
    <tr>
      <th>WhtHll_Rpwr</th>
      <td>115.0</td>
      <td>WhiteHill</td>
      <td>58.00</td>
      <td>0.504348</td>
    </tr>
  </tbody>
</table>
</div>
<br>


### Clause 51 periods of benefit

The table below indicates the AC and DC binding conditions for which load customer groups 
benefit from the investment via alleviated prices.  The rules for
these periods are described in paras. 353 - 356 of the Assumptions Book[^AB].  


<div class="container" style="max-width: 800px;">
<style type="text/css">
#T_585d4 th {
  text-align: center;
}
#T_585d4_row0_col0, #T_585d4_row0_col1, #T_585d4_row1_col0, #T_585d4_row1_col1, #T_585d4_row2_col0, #T_585d4_row2_col1, #T_585d4_row2_col3, #T_585d4_row2_col6 {
  background-color: white;
  color: grey;
  text-align: center;
  font-weight: bold;
}
#T_585d4_row0_col2, #T_585d4_row0_col3, #T_585d4_row0_col4, #T_585d4_row1_col5, #T_585d4_row1_col6, #T_585d4_row1_col7, #T_585d4_row2_col5, #T_585d4_row2_col7 {
  background-color: green;
  color: white;
  text-align: center;
  font-weight: bold;
}
#T_585d4_row0_col5, #T_585d4_row0_col6, #T_585d4_row0_col7, #T_585d4_row1_col2, #T_585d4_row1_col3, #T_585d4_row1_col4, #T_585d4_row2_col2, #T_585d4_row2_col4 {
  background-color: red;
  color: white;
  text-align: center;
  font-weight: bold;
}
</style>
<table id="T_585d4" class = "dataframe table table-sm table-striped table-hover">
  <thead>
    <tr>
      <th class="blank level0" >&nbsp;</th>
      <th id="T_585d4_level0_col0" class="col_heading level0 col0" >AC • DC ↑</th>
      <th id="T_585d4_level0_col1" class="col_heading level0 col1" >AC • DC ↓</th>
      <th id="T_585d4_level0_col2" class="col_heading level0 col2" >AC ↑ DC •</th>
      <th id="T_585d4_level0_col3" class="col_heading level0 col3" >AC ↑ DC ↑</th>
      <th id="T_585d4_level0_col4" class="col_heading level0 col4" >AC ↑ DC ↓</th>
      <th id="T_585d4_level0_col5" class="col_heading level0 col5" >AC ↓ DC •</th>
      <th id="T_585d4_level0_col6" class="col_heading level0 col6" >AC ↓ DC ↑</th>
      <th id="T_585d4_level0_col7" class="col_heading level0 col7" >AC ↓ DC ↓</th>
    </tr>
    <tr>
      <th class="index_name level0" >Region</th>
      <th class="blank col0" >&nbsp;</th>
      <th class="blank col1" >&nbsp;</th>
      <th class="blank col2" >&nbsp;</th>
      <th class="blank col3" >&nbsp;</th>
      <th class="blank col4" >&nbsp;</th>
      <th class="blank col5" >&nbsp;</th>
      <th class="blank col6" >&nbsp;</th>
      <th class="blank col7" >&nbsp;</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th id="T_585d4_level0_row0" class="row_heading level0 row0" >UNI</th>
      <td id="T_585d4_row0_col0" class="data row0 col0" >•</td>
      <td id="T_585d4_row0_col1" class="data row0 col1" >•</td>
      <td id="T_585d4_row0_col2" class="data row0 col2" >+</td>
      <td id="T_585d4_row0_col3" class="data row0 col3" >+</td>
      <td id="T_585d4_row0_col4" class="data row0 col4" >+</td>
      <td id="T_585d4_row0_col5" class="data row0 col5" >-</td>
      <td id="T_585d4_row0_col6" class="data row0 col6" >-</td>
      <td id="T_585d4_row0_col7" class="data row0 col7" >-</td>
    </tr>
    <tr>
      <th id="T_585d4_level0_row1" class="row_heading level0 row1" >LNI</th>
      <td id="T_585d4_row1_col0" class="data row1 col0" >•</td>
      <td id="T_585d4_row1_col1" class="data row1 col1" >•</td>
      <td id="T_585d4_row1_col2" class="data row1 col2" >-</td>
      <td id="T_585d4_row1_col3" class="data row1 col3" >-</td>
      <td id="T_585d4_row1_col4" class="data row1 col4" >-</td>
      <td id="T_585d4_row1_col5" class="data row1 col5" >+</td>
      <td id="T_585d4_row1_col6" class="data row1 col6" >+</td>
      <td id="T_585d4_row1_col7" class="data row1 col7" >+</td>
    </tr>
    <tr>
      <th id="T_585d4_level0_row2" class="row_heading level0 row2" >SI</th>
      <td id="T_585d4_row2_col0" class="data row2 col0" >•</td>
      <td id="T_585d4_row2_col1" class="data row2 col1" >•</td>
      <td id="T_585d4_row2_col2" class="data row2 col2" >-</td>
      <td id="T_585d4_row2_col3" class="data row2 col3" >•</td>
      <td id="T_585d4_row2_col4" class="data row2 col4" >-</td>
      <td id="T_585d4_row2_col5" class="data row2 col5" >+</td>
      <td id="T_585d4_row2_col6" class="data row2 col6" >•</td>
      <td id="T_585d4_row2_col7" class="data row2 col7" >+</td>
    </tr>
  </tbody>
</table>

Up/down arrows in the column headers represent North/South binding respectively; dots mean no binding.

Green "+" cells mean load customers benefit, red "-" cells mean they disbenefit, 
grey dots mean they neither benefit nor disbenefit.  The signs are reversed
for supply customer groups.
</div>
<br>

The following table shows the actual difference in the present value of time weighted average price between the factual and counterfactual
during the periods of benefit defined above.  Ideally the lowest values (the largest price decreases) should broadly 
correspond with green "+" cells in the table above.  Similarly the largest price increases should correspond to red "-" cells above.
The signs of the smaller values in the table below may not correspond to the load benefit periods above due to different hydro generation time series in
the factual and counterfactual.

<div class="container" style="max-width: 800px;">
<style type="text/css">
#T_c1b15 th {
  text-align: center;
}
#T_c1b15 td {
  text-align: right;
}
#T_c1b15_row0_col0, #T_c1b15_row1_col0, #T_c1b15_row2_col0 {
  background-color: #fffefe;
  color: #000000;
}
#T_c1b15_row0_col1 {
  background-color: #b0d8b0;
  color: #000000;
}
#T_c1b15_row0_col2 {
  background-color: #008000;
  color: #f1f1f1;
}
#T_c1b15_row0_col3 {
  background-color: #ecf6ec;
  color: #000000;
}
#T_c1b15_row0_col4, #T_c1b15_row1_col4 {
  background-color: #fff8f8;
  color: #000000;
}
#T_c1b15_row1_col1 {
  background-color: #fcfefc;
  color: #000000;
}
#T_c1b15_row1_col2 {
  background-color: #66b366;
  color: #f1f1f1;
}
#T_c1b15_row1_col3 {
  background-color: #fff6f6;
  color: #000000;
}
#T_c1b15_row2_col1 {
  background-color: #f0f8f0;
  color: #000000;
}
#T_c1b15_row2_col2 {
  background-color: #fffcfc;
  color: #000000;
}
#T_c1b15_row2_col3 {
  background-color: #ffdcdc;
  color: #000000;
}
#T_c1b15_row2_col4 {
  background-color: #f8fcf8;
  color: #000000;
}
</style>
<table id="T_c1b15" class = "dataframe table table-sm table-striped table-hover">
  <thead>
    <tr>
      <th class="blank level0" >&nbsp;</th>
      <th id="T_c1b15_level0_col0" class="col_heading level0 col0" >AC•DC↑</th>
      <th id="T_c1b15_level0_col1" class="col_heading level0 col1" >AC↑DC•</th>
      <th id="T_c1b15_level0_col2" class="col_heading level0 col2" >AC↑DC↑</th>
      <th id="T_c1b15_level0_col3" class="col_heading level0 col3" >AC↓DC•</th>
      <th id="T_c1b15_level0_col4" class="col_heading level0 col4" >AC↓DC↑</th>
    </tr>
    <tr>
      <th class="index_name level0" >Region</th>
      <th class="blank col0" >&nbsp;</th>
      <th class="blank col1" >&nbsp;</th>
      <th class="blank col2" >&nbsp;</th>
      <th class="blank col3" >&nbsp;</th>
      <th class="blank col4" >&nbsp;</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th id="T_c1b15_level0_row0" class="row_heading level0 row0" >UNI</th>
      <td id="T_c1b15_row0_col0" class="data row0 col0" >0.0</td>
      <td id="T_c1b15_row0_col1" class="data row0 col1" >-1.5</td>
      <td id="T_c1b15_row0_col2" class="data row0 col2" >-4.9</td>
      <td id="T_c1b15_row0_col3" class="data row0 col3" >-0.4</td>
      <td id="T_c1b15_row0_col4" class="data row0 col4" >0.1</td>
    </tr>
    <tr>
      <th id="T_c1b15_level0_row1" class="row_heading level0 row1" >LNI</th>
      <td id="T_c1b15_row1_col0" class="data row1 col0" >0.0</td>
      <td id="T_c1b15_row1_col1" class="data row1 col1" >-0.1</td>
      <td id="T_c1b15_row1_col2" class="data row1 col2" >-2.9</td>
      <td id="T_c1b15_row1_col3" class="data row1 col3" >0.2</td>
      <td id="T_c1b15_row1_col4" class="data row1 col4" >0.1</td>
    </tr>
    <tr>
      <th id="T_c1b15_level0_row2" class="row_heading level0 row2" >SI</th>
      <td id="T_c1b15_row2_col0" class="data row2 col0" >0.0</td>
      <td id="T_c1b15_row2_col1" class="data row2 col1" >-0.3</td>
      <td id="T_c1b15_row2_col2" class="data row2 col2" >0.1</td>
      <td id="T_c1b15_row2_col3" class="data row2 col3" >0.7</td>
      <td id="T_c1b15_row2_col4" class="data row2 col4" >-0.1</td>
    </tr>
  </tbody>
</table>

The difference in time weighted average price (F - CF) for different counterfactual AC and DC binding conditions.  
The factual values are averaged over the periods (and hydro scenarios) where the binding conditions applied in the counterfactual. 
</div>
<br>


### Step load adjustments for consumer PVEMBD

According to the TPM[^step_loads], benefits due to large
steps in future demand should not be included when determining allocations.

At each bus with identified step loads we multiply load benefits by:

\[\textrm{step load adjustment} = 1 - \frac{\textrm{PV step loads}}{\textrm{PV total loads}}\],
where PV indicates the present value of these loads summed over the BBI investment period.
Step loads for each market scenario are provided in the input file 
`sddp2tpm_data/data/step_loads.csv`, and the total load
comes from the `demxba` SDDP output. 


The step load adjustments below are applied to the `bus_constraint_pv.csv` and 
`bus_delta_pv.csv` outputs from clause51 postprocessing.
<br>
<h4>Step load adjustment factor</h4>
<p><i>Output file: step_load_adj.csv</i></p>
<div class="table-responsive" style="max-width: 1000px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th>bus</th>
      <th>ALB220</th>
    </tr>
    <tr>
      <th>edgs_name</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>disruptive</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>environmental</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>global</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>growth</th>
      <td>1.0</td>
    </tr>
    <tr>
      <th>reference</th>
      <td>1.0</td>
    </tr>
  </tbody>
</table>
</div>



<br>

### Reallocation of load growth to EDBs at multi-customer nodes

Where there is more than one customer at a node, we attribute the load portion
 of PVEMBD to each customer based on their offtake intra-regional allocator (IRA) as 
 a proportion of the total of all customers' offtake IRAs at that connection location.  
 Where some customers are non-distribution customer and others are electricity 
 distribution businesses (EDB), we assume that the load growth at that connection location is 
 wholly attributable to distributor customers, consistent with our demand forecasts 
 for non-distributor customers, which generally assume no load growth.

 The following table shows the nodes with multiple customers that include both
 EDB and non EDB customers, and the reallocation of load growth to EDBs at these nodes.

For non-EDB customers:
\[alloc_{non-EDB} = \frac{w_{IRA}(PVdemand - PV\Delta demand)}{PVdemand}\]
For EDBs:
\[alloc_{EDB} = alloc_{non-EDB} + \frac{w_{EDB}PV\Delta demand}{PVdemand}\]
, where \(w_{IRA}\) (`ira_weight`) is the customer's IRA offtake divided by the total offtake at that location,
and \(w_{EDB}\) (`edb_weight`) is the EDB's offtake divided by the total EDB offtake at that location.

Nodes affected by this calculation are identified in the input `sddp2tpm_data/data/multi_cust_nodes.csv`.  
The IRA offtakes for each customer/location are from the input `sddp2tpm_data/data/ira.csv`,
and the demand and its growth are determined from the annual demand (averaged over hydro scenarios and weighted over
market scenarios), which is in the clause51 output `bus_annual.pv`.

Because demand growth depends on the market scenario, load reallocation is also
EDGS dependant.

The `alloc` column below scales the
`bus_constraint_pv.csv` and `bus_annual_delta_pv.csv` `load_supplied` data, after summing over the buses for each location.

*Output file: load_reallocation.csv*

<div class="table-responsive container" style="max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th></th>
      <th>offtake</th>
      <th>injection</th>
      <th>load_type</th>
      <th>offtake_loc</th>
      <th>ira_weight</th>
      <th>edb_offtake_loc</th>
      <th>edb_weight</th>
      <th>demand_growth_pv</th>
      <th>demand_pv</th>
      <th>alloc</th>
    </tr>
    <tr>
      <th>edgs_name</th>
      <th>cust_code</th>
      <th>location</th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>188.300166</td>
      <td>1530.535625</td>
      <td>0.996640</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>165.699860</td>
      <td>1486.572079</td>
      <td>0.996596</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>114.500409</td>
      <td>1400.667980</td>
      <td>0.996482</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>138.878602</td>
      <td>1431.094245</td>
      <td>0.996541</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>ARI</th>
      <td>8.394852e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>8.427137e+07</td>
      <td>0.996169</td>
      <td>8.394852e+07</td>
      <td>1.000000</td>
      <td>128.382737</td>
      <td>1419.828842</td>
      <td>0.996515</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>188.300166</td>
      <td>1530.535625</td>
      <td>0.003360</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>165.699860</td>
      <td>1486.572079</td>
      <td>0.003404</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>114.500409</td>
      <td>1400.667980</td>
      <td>0.003518</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>138.878602</td>
      <td>1431.094245</td>
      <td>0.003459</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MRPL</th>
      <th>ARI</th>
      <td>3.228442e+05</td>
      <td>8.739429e+08</td>
      <td>Generator</td>
      <td>8.427137e+07</td>
      <td>0.003831</td>
      <td>8.394852e+07</td>
      <td>0.000000</td>
      <td>128.382737</td>
      <td>1419.828842</td>
      <td>0.003485</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>843.684460</td>
      <td>5331.057238</td>
      <td>0.995688</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>756.642768</td>
      <td>5186.329688</td>
      <td>0.995624</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>352.306189</td>
      <td>4454.330941</td>
      <td>0.995282</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>605.669987</td>
      <td>4844.917198</td>
      <td>0.995517</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>BPE</th>
      <td>3.594438e+08</td>
      <td>1.554200e+03</td>
      <td>EDB</td>
      <td>3.612948e+08</td>
      <td>0.994877</td>
      <td>3.594438e+08</td>
      <td>1.000000</td>
      <td>487.693167</td>
      <td>4683.222707</td>
      <td>0.995410</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>843.684460</td>
      <td>5331.057238</td>
      <td>0.004312</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>756.642768</td>
      <td>5186.329688</td>
      <td>0.004376</td>
    </tr>
    <tr>
      <th>global</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>352.306189</td>
      <td>4454.330941</td>
      <td>0.004718</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>605.669987</td>
      <td>4844.917198</td>
      <td>0.004483</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>TRNZ</th>
      <th>BPE</th>
      <td>1.850996e+06</td>
      <td>6.838000e+02</td>
      <td>Industrial</td>
      <td>3.612948e+08</td>
      <td>0.005123</td>
      <td>3.594438e+08</td>
      <td>0.000000</td>
      <td>487.693167</td>
      <td>4683.222707</td>
      <td>0.004590</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>120.999927</td>
      <td>240.701533</td>
      <td>0.984138</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>100.719154</td>
      <td>216.873804</td>
      <td>0.982917</td>
    </tr>
    <tr>
      <th>global</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>92.442908</td>
      <td>190.434980</td>
      <td>0.983587</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>85.521132</td>
      <td>188.499761</td>
      <td>0.982575</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>DUNE</th>
      <th>CYD</th>
      <td>5.553553e+06</td>
      <td>4.880548e+07</td>
      <td>EDB</td>
      <td>5.736523e+06</td>
      <td>0.968104</td>
      <td>5.553553e+06</td>
      <td>1.000000</td>
      <td>81.695628</td>
      <td>184.676921</td>
      <td>0.982214</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>120.999927</td>
      <td>240.701533</td>
      <td>0.015862</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>100.719154</td>
      <td>216.873804</td>
      <td>0.017083</td>
    </tr>
    <tr>
      <th>global</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>92.442908</td>
      <td>190.434980</td>
      <td>0.016413</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>85.521132</td>
      <td>188.499761</td>
      <td>0.017425</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>CTCT</th>
      <th>CYD</th>
      <td>1.829704e+05</td>
      <td>2.149593e+09</td>
      <td>Generator</td>
      <td>5.736523e+06</td>
      <td>0.031896</td>
      <td>5.553553e+06</td>
      <td>0.000000</td>
      <td>81.695628</td>
      <td>184.676921</td>
      <td>0.017786</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>672.792882</td>
      <td>14036.125876</td>
      <td>0.304508</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>575.704197</td>
      <td>13330.401741</td>
      <td>0.301041</td>
    </tr>
    <tr>
      <th>global</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>330.077475</td>
      <td>12864.627305</td>
      <td>0.288235</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>528.158407</td>
      <td>13613.561347</td>
      <td>0.297833</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>COUP</th>
      <th>GLN</th>
      <td>1.686322e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>6.257407e+08</td>
      <td>0.269492</td>
      <td>1.686322e+08</td>
      <td>1.000000</td>
      <td>433.849482</td>
      <td>13502.258360</td>
      <td>0.292965</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>672.792882</td>
      <td>14036.125876</td>
      <td>0.695492</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>575.704197</td>
      <td>13330.401741</td>
      <td>0.698959</td>
    </tr>
    <tr>
      <th>global</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>330.077475</td>
      <td>12864.627305</td>
      <td>0.711765</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>528.158407</td>
      <td>13613.561347</td>
      <td>0.702167</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>NZST</th>
      <th>GLN</th>
      <td>4.571085e+08</td>
      <td>9.569720e+04</td>
      <td>Industrial</td>
      <td>6.257407e+08</td>
      <td>0.730508</td>
      <td>1.686322e+08</td>
      <td>0.000000</td>
      <td>433.849482</td>
      <td>13502.258360</td>
      <td>0.707035</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1655.974364</td>
      <td>7060.321840</td>
      <td>0.997474</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1600.365947</td>
      <td>7162.737320</td>
      <td>0.997497</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-2217.856732</td>
      <td>5962.102998</td>
      <td>0.997193</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1634.810034</td>
      <td>6970.189435</td>
      <td>0.997474</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WELE</th>
      <th>HAM</th>
      <td>7.576371e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>7.591904e+08</td>
      <td>0.997954</td>
      <td>7.576371e+08</td>
      <td>1.000000</td>
      <td>-1896.244465</td>
      <td>6565.839527</td>
      <td>0.997363</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1655.974364</td>
      <td>7060.321840</td>
      <td>0.002526</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1600.365947</td>
      <td>7162.737320</td>
      <td>0.002503</td>
    </tr>
    <tr>
      <th>global</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-2217.856732</td>
      <td>5962.102998</td>
      <td>0.002807</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1634.810034</td>
      <td>6970.189435</td>
      <td>0.002526</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>TRNZ</th>
      <th>HAM</th>
      <td>1.553306e+06</td>
      <td>1.624120e+04</td>
      <td>Industrial</td>
      <td>7.591904e+08</td>
      <td>0.002046</td>
      <td>7.576371e+08</td>
      <td>0.000000</td>
      <td>-1896.244465</td>
      <td>6565.839527</td>
      <td>0.002637</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1141.974002</td>
      <td>3785.492997</td>
      <td>0.991013</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1141.205356</td>
      <td>3780.755133</td>
      <td>0.991015</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>963.643425</td>
      <td>3478.060183</td>
      <td>0.990696</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1094.041484</td>
      <td>3686.972399</td>
      <td>0.990949</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WELE</th>
      <th>HLY</th>
      <td>1.320209e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.337422e+08</td>
      <td>0.987130</td>
      <td>1.320209e+08</td>
      <td>1.000000</td>
      <td>1035.840150</td>
      <td>3603.767727</td>
      <td>0.990829</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1141.974002</td>
      <td>3785.492997</td>
      <td>0.008987</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1141.205356</td>
      <td>3780.755133</td>
      <td>0.008985</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>963.643425</td>
      <td>3478.060183</td>
      <td>0.009304</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1094.041484</td>
      <td>3686.972399</td>
      <td>0.009051</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>HLY</th>
      <td>1.721243e+06</td>
      <td>3.981514e+09</td>
      <td>Generator</td>
      <td>1.337422e+08</td>
      <td>0.012870</td>
      <td>1.320209e+08</td>
      <td>0.000000</td>
      <td>1035.840150</td>
      <td>3603.767727</td>
      <td>0.009171</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>264.367643</td>
      <td>4665.810416</td>
      <td>0.688334</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>216.799565</td>
      <td>4576.970072</td>
      <td>0.685264</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>72.644724</td>
      <td>4324.121283</td>
      <td>0.675165</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>166.413213</td>
      <td>4455.416474</td>
      <td>0.681954</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>HWA</th>
      <td>1.559637e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.329158e+08</td>
      <td>0.669614</td>
      <td>1.559637e+08</td>
      <td>1.000000</td>
      <td>129.666386</td>
      <td>4398.714615</td>
      <td>0.679353</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>264.367643</td>
      <td>4665.810416</td>
      <td>0.000873</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>216.799565</td>
      <td>4576.970072</td>
      <td>0.000882</td>
    </tr>
    <tr>
      <th>global</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>72.644724</td>
      <td>4324.121283</td>
      <td>0.000910</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>166.413213</td>
      <td>4455.416474</td>
      <td>0.000891</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>KIWI</th>
      <th>HWA</th>
      <td>2.156468e+05</td>
      <td>1.510133e+08</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.000926</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>129.666386</td>
      <td>4398.714615</td>
      <td>0.000899</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>264.367643</td>
      <td>4665.810416</td>
      <td>0.310792</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>216.799565</td>
      <td>4576.970072</td>
      <td>0.313854</td>
    </tr>
    <tr>
      <th>global</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>72.644724</td>
      <td>4324.121283</td>
      <td>0.323925</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>166.413213</td>
      <td>4455.416474</td>
      <td>0.317154</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>KUPE</th>
      <th>HWA</th>
      <td>7.673639e+07</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.329158e+08</td>
      <td>0.329460</td>
      <td>1.559637e+08</td>
      <td>0.000000</td>
      <td>129.666386</td>
      <td>4398.714615</td>
      <td>0.319748</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>1204.354498</td>
      <td>7248.140306</td>
      <td>0.997451</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>967.580283</td>
      <td>6826.254079</td>
      <td>0.997376</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>446.834265</td>
      <td>5879.197401</td>
      <td>0.997175</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>705.172627</td>
      <td>6262.415880</td>
      <td>0.997287</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>LTN</th>
      <td>1.612535e+08</td>
      <td>3.497389e+06</td>
      <td>EDB</td>
      <td>1.617480e+08</td>
      <td>0.996942</td>
      <td>1.612535e+08</td>
      <td>1.000000</td>
      <td>589.172851</td>
      <td>6114.342360</td>
      <td>0.997237</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>1204.354498</td>
      <td>7248.140306</td>
      <td>0.002549</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>967.580283</td>
      <td>6826.254079</td>
      <td>0.002624</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>446.834265</td>
      <td>5879.197401</td>
      <td>0.002825</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>705.172627</td>
      <td>6262.415880</td>
      <td>0.002713</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MSVP</th>
      <th>LTN</th>
      <td>4.945487e+05</td>
      <td>5.590925e+08</td>
      <td>Generator</td>
      <td>1.617480e+08</td>
      <td>0.003058</td>
      <td>1.612535e+08</td>
      <td>0.000000</td>
      <td>589.172851</td>
      <td>6114.342360</td>
      <td>0.002763</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>3605.742258</td>
      <td>31048.143930</td>
      <td>0.993256</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>3461.965923</td>
      <td>30779.658342</td>
      <td>0.993228</td>
    </tr>
    <tr>
      <th>global</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>1108.458292</td>
      <td>26592.713912</td>
      <td>0.992688</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>2755.195131</td>
      <td>29418.712340</td>
      <td>0.993085</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>VECT</th>
      <th>PEN</th>
      <td>2.138725e+09</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.155169e+09</td>
      <td>0.992370</td>
      <td>2.138725e+09</td>
      <td>1.000000</td>
      <td>2040.183827</td>
      <td>28357.546195</td>
      <td>0.992919</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3605.742258</td>
      <td>31048.143930</td>
      <td>0.000189</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3461.965923</td>
      <td>30779.658342</td>
      <td>0.000190</td>
    </tr>
    <tr>
      <th>global</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>1108.458292</td>
      <td>26592.713912</td>
      <td>0.000205</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2755.195131</td>
      <td>29418.712340</td>
      <td>0.000194</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4.608108e+05</td>
      <td>0.000000e+00</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.000214</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2040.183827</td>
      <td>28357.546195</td>
      <td>0.000198</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3605.742258</td>
      <td>31048.143930</td>
      <td>0.006555</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>3461.965923</td>
      <td>30779.658342</td>
      <td>0.006582</td>
    </tr>
    <tr>
      <th>global</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>1108.458292</td>
      <td>26592.713912</td>
      <td>0.007107</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2755.195131</td>
      <td>29418.712340</td>
      <td>0.006722</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>TRNZ</th>
      <th>PEN</th>
      <td>1.598319e+07</td>
      <td>1.440000e+01</td>
      <td>Industrial</td>
      <td>2.155169e+09</td>
      <td>0.007416</td>
      <td>2.138725e+09</td>
      <td>0.000000</td>
      <td>2040.183827</td>
      <td>28357.546195</td>
      <td>0.006883</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>2264.807364</td>
      <td>5428.210156</td>
      <td>0.983698</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>1621.653109</td>
      <td>4273.440376</td>
      <td>0.982642</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>571.803467</td>
      <td>2477.650654</td>
      <td>0.978483</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>965.950565</td>
      <td>2924.423516</td>
      <td>0.981267</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>SFD</th>
      <td>1.284703e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.321674e+08</td>
      <td>0.972027</td>
      <td>1.284703e+08</td>
      <td>1.000000</td>
      <td>791.634262</td>
      <td>2733.251772</td>
      <td>0.980129</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>2264.807364</td>
      <td>5428.210156</td>
      <td>0.016302</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>1621.653109</td>
      <td>4273.440376</td>
      <td>0.017358</td>
    </tr>
    <tr>
      <th>global</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>571.803467</td>
      <td>2477.650654</td>
      <td>0.021517</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>965.950565</td>
      <td>2924.423516</td>
      <td>0.018733</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>CTCT</th>
      <th>SFD</th>
      <td>3.697118e+06</td>
      <td>9.982725e+08</td>
      <td>Generator</td>
      <td>1.321674e+08</td>
      <td>0.027973</td>
      <td>1.284703e+08</td>
      <td>0.000000</td>
      <td>791.634262</td>
      <td>2733.251772</td>
      <td>0.019871</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>1021.925975</td>
      <td>2551.432745</td>
      <td>0.997085</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>724.135724</td>
      <td>2016.247185</td>
      <td>0.996884</td>
    </tr>
    <tr>
      <th>global</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>269.911181</td>
      <td>1231.323675</td>
      <td>0.996204</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>432.489110</td>
      <td>1409.427741</td>
      <td>0.996630</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>ALPE</th>
      <th>TKA</th>
      <td>2.009443e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.019261e+07</td>
      <td>0.995138</td>
      <td>2.009443e+07</td>
      <td>1.000000</td>
      <td>358.669539</td>
      <td>1332.013237</td>
      <td>0.996447</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>1021.925975</td>
      <td>2551.432745</td>
      <td>0.002915</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>724.135724</td>
      <td>2016.247185</td>
      <td>0.003116</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>269.911181</td>
      <td>1231.323675</td>
      <td>0.003796</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>432.489110</td>
      <td>1409.427741</td>
      <td>0.003370</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>TKA</th>
      <td>9.817760e+04</td>
      <td>1.439613e+08</td>
      <td>Generator</td>
      <td>2.019261e+07</td>
      <td>0.004862</td>
      <td>2.009443e+07</td>
      <td>0.000000</td>
      <td>358.669539</td>
      <td>1332.013237</td>
      <td>0.003553</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>170.743892</td>
      <td>580.356897</td>
      <td>0.950921</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>141.062334</td>
      <td>529.178627</td>
      <td>0.948999</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>67.722377</td>
      <td>413.287091</td>
      <td>0.941857</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>89.194657</td>
      <td>436.019061</td>
      <td>0.944687</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WTOM</th>
      <th>TKU</th>
      <td>3.543444e+07</td>
      <td>6.295660e+04</td>
      <td>EDB</td>
      <td>3.808261e+07</td>
      <td>0.930462</td>
      <td>3.543444e+07</td>
      <td>1.000000</td>
      <td>77.452385</td>
      <td>423.678042</td>
      <td>0.943175</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>170.743892</td>
      <td>580.356897</td>
      <td>0.049079</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>141.062334</td>
      <td>529.178627</td>
      <td>0.051001</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>67.722377</td>
      <td>413.287091</td>
      <td>0.058143</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>89.194657</td>
      <td>436.019061</td>
      <td>0.055313</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>TKU</th>
      <td>2.648171e+06</td>
      <td>6.998804e+08</td>
      <td>Generator</td>
      <td>3.808261e+07</td>
      <td>0.069538</td>
      <td>3.543444e+07</td>
      <td>0.000000</td>
      <td>77.452385</td>
      <td>423.678042</td>
      <td>0.056825</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>884.550600</td>
      <td>4521.448391</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>799.305732</td>
      <td>4370.992587</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>global</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>407.814389</td>
      <td>3662.792402</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>671.376118</td>
      <td>4061.827559</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>EAST</th>
      <th>TUI</th>
      <td>2.963624e+08</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.963631e+08</td>
      <td>0.999998</td>
      <td>2.963624e+08</td>
      <td>1.000000</td>
      <td>547.302325</td>
      <td>3893.031350</td>
      <td>0.999998</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>884.550600</td>
      <td>4521.448391</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>799.305732</td>
      <td>4370.992587</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>global</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>407.814389</td>
      <td>3662.792402</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>671.376118</td>
      <td>4061.827559</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>GENE</th>
      <th>TUI</th>
      <td>7.160000e+02</td>
      <td>4.614465e+08</td>
      <td>Generator</td>
      <td>2.963631e+08</td>
      <td>0.000002</td>
      <td>2.963624e+08</td>
      <td>0.000000</td>
      <td>547.302325</td>
      <td>3893.031350</td>
      <td>0.000002</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>111.716642</td>
      <td>458.050818</td>
      <td>0.489901</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>94.148397</td>
      <td>426.568841</td>
      <td>0.487953</td>
    </tr>
    <tr>
      <th>global</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>37.207417</td>
      <td>327.916876</td>
      <td>0.478944</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>69.101730</td>
      <td>372.083892</td>
      <td>0.485013</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>ALPE</th>
      <th>TWZ</th>
      <td>1.587970e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.469411</td>
      <td>2.869365e+07</td>
      <td>0.553422</td>
      <td>53.914142</td>
      <td>352.634030</td>
      <td>0.482256</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>111.716642</td>
      <td>458.050818</td>
      <td>0.395320</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>94.148397</td>
      <td>426.568841</td>
      <td>0.393749</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>37.207417</td>
      <td>327.916876</td>
      <td>0.386478</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>69.101730</td>
      <td>372.083892</td>
      <td>0.391376</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WATA</th>
      <th>TWZ</th>
      <td>1.281395e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>3.382897e+07</td>
      <td>0.378786</td>
      <td>2.869365e+07</td>
      <td>0.446578</td>
      <td>53.914142</td>
      <td>352.634030</td>
      <td>0.389151</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>111.716642</td>
      <td>458.050818</td>
      <td>0.114779</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>94.148397</td>
      <td>426.568841</td>
      <td>0.118298</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>37.207417</td>
      <td>327.916876</td>
      <td>0.134578</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>69.101730</td>
      <td>372.083892</td>
      <td>0.123610</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MERI</th>
      <th>TWZ</th>
      <td>5.135323e+06</td>
      <td>0.000000e+00</td>
      <td>Generator</td>
      <td>3.382897e+07</td>
      <td>0.151803</td>
      <td>2.869365e+07</td>
      <td>0.000000</td>
      <td>53.914142</td>
      <td>352.634030</td>
      <td>0.128593</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>90.874584</td>
      <td>350.259673</td>
      <td>0.964298</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>67.124858</td>
      <td>307.254347</td>
      <td>0.962322</td>
    </tr>
    <tr>
      <th>global</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>21.912604</td>
      <td>229.652837</td>
      <td>0.956390</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>39.854260</td>
      <td>251.498863</td>
      <td>0.959430</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>SCAN</th>
      <th>WDV</th>
      <td>1.317270e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>1.383992e+07</td>
      <td>0.951790</td>
      <td>1.317270e+07</td>
      <td>1.000000</td>
      <td>31.636784</td>
      <td>241.971650</td>
      <td>0.958093</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>90.874584</td>
      <td>350.259673</td>
      <td>0.035702</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>67.124858</td>
      <td>307.254347</td>
      <td>0.037678</td>
    </tr>
    <tr>
      <th>global</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>21.912604</td>
      <td>229.652837</td>
      <td>0.043610</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>39.854260</td>
      <td>251.498863</td>
      <td>0.040570</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>MELT</th>
      <th>WDV</th>
      <td>6.672206e+05</td>
      <td>2.520301e+08</td>
      <td>Generator</td>
      <td>1.383992e+07</td>
      <td>0.048210</td>
      <td>1.317270e+07</td>
      <td>0.000000</td>
      <td>31.636784</td>
      <td>241.971650</td>
      <td>0.041907</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>292.383651</td>
      <td>2988.741272</td>
      <td>0.993652</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>266.130159</td>
      <td>2950.139192</td>
      <td>0.993598</td>
    </tr>
    <tr>
      <th>global</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>45.764238</td>
      <td>2569.065260</td>
      <td>0.993089</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>173.251304</td>
      <td>2777.064955</td>
      <td>0.993402</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>UNIS</th>
      <th>WRK</th>
      <td>9.726822e+06</td>
      <td>1.904989e+08</td>
      <td>EDB</td>
      <td>9.795753e+06</td>
      <td>0.992963</td>
      <td>9.726822e+06</td>
      <td>1.000000</td>
      <td>116.386595</td>
      <td>2695.737584</td>
      <td>0.993267</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>292.383651</td>
      <td>2988.741272</td>
      <td>0.006348</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>266.130159</td>
      <td>2950.139192</td>
      <td>0.006402</td>
    </tr>
    <tr>
      <th>global</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>45.764238</td>
      <td>2569.065260</td>
      <td>0.006911</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>173.251304</td>
      <td>2777.064955</td>
      <td>0.006598</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>CTCT</th>
      <th>WRK</th>
      <td>6.893100e+04</td>
      <td>1.036159e+09</td>
      <td>Generator</td>
      <td>9.795753e+06</td>
      <td>0.007037</td>
      <td>9.726822e+06</td>
      <td>0.000000</td>
      <td>116.386595</td>
      <td>2695.737584</td>
      <td>0.006733</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>108.226157</td>
      <td>416.348434</td>
      <td>0.985640</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>80.769062</td>
      <td>366.387702</td>
      <td>0.984874</td>
    </tr>
    <tr>
      <th>global</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>28.797472</td>
      <td>275.166172</td>
      <td>0.982627</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>51.595754</td>
      <td>305.318232</td>
      <td>0.983875</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>POCO</th>
      <th>WVY</th>
      <td>2.235968e+07</td>
      <td>0.000000e+00</td>
      <td>EDB</td>
      <td>2.280212e+07</td>
      <td>0.980596</td>
      <td>2.235968e+07</td>
      <td>1.000000</td>
      <td>41.272074</td>
      <td>292.819452</td>
      <td>0.983331</td>
    </tr>
    <tr>
      <th>disruptive</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>108.226157</td>
      <td>416.348434</td>
      <td>0.014360</td>
    </tr>
    <tr>
      <th>environmental</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>80.769062</td>
      <td>366.387702</td>
      <td>0.015126</td>
    </tr>
    <tr>
      <th>global</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>28.797472</td>
      <td>275.166172</td>
      <td>0.017373</td>
    </tr>
    <tr>
      <th>growth</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>51.595754</td>
      <td>305.318232</td>
      <td>0.016125</td>
    </tr>
    <tr>
      <th>reference</th>
      <th>WAV1</th>
      <th>WVY</th>
      <td>4.424450e+05</td>
      <td>4.390789e+08</td>
      <td>Generator</td>
      <td>2.280212e+07</td>
      <td>0.019404</td>
      <td>2.235968e+07</td>
      <td>0.000000</td>
      <td>41.272074</td>
      <td>292.819452</td>
      <td>0.016669</td>
    </tr>
  </tbody>
</table>
</div>

<br>

### Regional Customer Groups

This topic is covered by Clause 50 of the TPM.

Regional customer groups (RCG) are obtained by: 

1. seperating the customer connections into the modelled regions.  The modelled regions are groups of substations that are
seperated by transmission constraints being alleviated by the grid investment and 
the HVDC link.

2. classifying the customer connections in these regions as "supply" or "demand" 
depending on the absolute value of the generation and load PVEMBDs for that customer 
connection

3. Separating the demand and supply customer connections into the regional customer
groups based on the type of load or generation.  This supports the goal of providing 
customer allocations that are broadly proportionate to positive net private benefit (NPB)[^NPB].  With this in mind we
create "load_with_gen" and "gen_with_load" RCGs for customer connections that 
have comparable load and generation benefits[^similar].

#### RCGs and their NPBs for this investment

*Output file: all_groups.csv*
<div class="container" style="max-width: 600px;">
<style type="text/css">
#T_33fd9_row0_col1, #T_33fd9_row1_col1, #T_33fd9_row2_col1, #T_33fd9_row3_col1, #T_33fd9_row4_col1, #T_33fd9_row5_col1, #T_33fd9_row6_col1, #T_33fd9_row7_col1, #T_33fd9_row8_col1, #T_33fd9_row9_col1, #T_33fd9_row10_col1, #T_33fd9_row11_col1, #T_33fd9_row12_col1, #T_33fd9_row13_col1, #T_33fd9_row14_col1 {
  color: black;
}
#T_33fd9_row15_col1, #T_33fd9_row16_col1, #T_33fd9_row17_col1, #T_33fd9_row18_col1, #T_33fd9_row19_col1, #T_33fd9_row20_col1, #T_33fd9_row21_col1, #T_33fd9_row22_col1, #T_33fd9_row23_col1, #T_33fd9_row24_col1, #T_33fd9_row25_col1, #T_33fd9_row26_col1, #T_33fd9_row27_col1, #T_33fd9_row28_col1, #T_33fd9_row29_col1 {
  color: red;
}
</style>
<table id="T_33fd9" class = "dataframe table table-sm table-striped table-hover">
  <thead>
    <tr>
      <th id="T_33fd9_level0_col0" class="col_heading level0 col0" >prov_group</th>
      <th id="T_33fd9_level0_col1" class="col_heading level0 col1" >npb</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td id="T_33fd9_row0_col0" class="data row0 col0" >UNI_Non-industrial</td>
      <td id="T_33fd9_row0_col1" class="data row0 col1" >159557.5001</td>
    </tr>
    <tr>
      <td id="T_33fd9_row1_col0" class="data row1 col0" >SI_storage</td>
      <td id="T_33fd9_row1_col1" class="data row1 col1" >122491.3163</td>
    </tr>
    <tr>
      <td id="T_33fd9_row2_col0" class="data row2 col0" >LNI_wind</td>
      <td id="T_33fd9_row2_col1" class="data row2 col1" >24597.1318</td>
    </tr>
    <tr>
      <td id="T_33fd9_row3_col0" class="data row3 col0" >UNI_Industrial</td>
      <td id="T_33fd9_row3_col1" class="data row3 col1" >10139.8053</td>
    </tr>
    <tr>
      <td id="T_33fd9_row4_col0" class="data row4 col0" >LNI_cogen</td>
      <td id="T_33fd9_row4_col1" class="data row4 col1" >1367.4954</td>
    </tr>
    <tr>
      <td id="T_33fd9_row5_col0" class="data row5 col0" >LNI_run of river</td>
      <td id="T_33fd9_row5_col1" class="data row5 col1" >691.2461</td>
    </tr>
    <tr>
      <td id="T_33fd9_row6_col0" class="data row6 col0" >LNI_gen_with_load</td>
      <td id="T_33fd9_row6_col1" class="data row6 col1" >534.7793</td>
    </tr>
    <tr>
      <td id="T_33fd9_row7_col0" class="data row7 col0" >SI_run of river</td>
      <td id="T_33fd9_row7_col1" class="data row7 col1" >371.5213</td>
    </tr>
    <tr>
      <td id="T_33fd9_row8_col0" class="data row8 col0" >LNI_peaker</td>
      <td id="T_33fd9_row8_col1" class="data row8 col1" >123.2704</td>
    </tr>
    <tr>
      <td id="T_33fd9_row9_col0" class="data row9 col0" >SI_wind</td>
      <td id="T_33fd9_row9_col1" class="data row9 col1" >5.5889</td>
    </tr>
    <tr>
      <td id="T_33fd9_row10_col0" class="data row10 col0" >LNI_solar</td>
      <td id="T_33fd9_row10_col1" class="data row10 col1" >1.7809</td>
    </tr>
    <tr>
      <td id="T_33fd9_row11_col0" class="data row11 col0" >SI_solar</td>
      <td id="T_33fd9_row11_col1" class="data row11 col1" >1.5690</td>
    </tr>
    <tr>
      <td id="T_33fd9_row12_col0" class="data row12 col0" >LNI_battery</td>
      <td id="T_33fd9_row12_col1" class="data row12 col1" >0.1046</td>
    </tr>
    <tr>
      <td id="T_33fd9_row13_col0" class="data row13 col0" >UNI_peaker</td>
      <td id="T_33fd9_row13_col1" class="data row13 col1" >0.0375</td>
    </tr>
    <tr>
      <td id="T_33fd9_row14_col0" class="data row14 col0" >SI_battery</td>
      <td id="T_33fd9_row14_col1" class="data row14 col1" >0.0030</td>
    </tr>
    <tr>
      <td id="T_33fd9_row15_col0" class="data row15 col0" >UNI_battery</td>
      <td id="T_33fd9_row15_col1" class="data row15 col1" >-0.0537</td>
    </tr>
    <tr>
      <td id="T_33fd9_row16_col0" class="data row16 col0" >SI_peaker</td>
      <td id="T_33fd9_row16_col1" class="data row16 col1" >-0.0850</td>
    </tr>
    <tr>
      <td id="T_33fd9_row17_col0" class="data row17 col0" >UNI_solar</td>
      <td id="T_33fd9_row17_col1" class="data row17 col1" >-3.6288</td>
    </tr>
    <tr>
      <td id="T_33fd9_row18_col0" class="data row18 col0" >SI_load_with_gen</td>
      <td id="T_33fd9_row18_col1" class="data row18 col1" >-552.8581</td>
    </tr>
    <tr>
      <td id="T_33fd9_row19_col0" class="data row19 col0" >UNI_gen_with_load</td>
      <td id="T_33fd9_row19_col1" class="data row19 col1" >-647.2829</td>
    </tr>
    <tr>
      <td id="T_33fd9_row20_col0" class="data row20 col0" >LNI_load_with_gen</td>
      <td id="T_33fd9_row20_col1" class="data row20 col1" >-775.0897</td>
    </tr>
    <tr>
      <td id="T_33fd9_row21_col0" class="data row21 col0" >UNI_commit</td>
      <td id="T_33fd9_row21_col1" class="data row21 col1" >-940.2805</td>
    </tr>
    <tr>
      <td id="T_33fd9_row22_col0" class="data row22 col0" >LNI_Industrial</td>
      <td id="T_33fd9_row22_col1" class="data row22 col1" >-1439.4863</td>
    </tr>
    <tr>
      <td id="T_33fd9_row23_col0" class="data row23 col0" >UNI_wind</td>
      <td id="T_33fd9_row23_col1" class="data row23 col1" >-5140.4901</td>
    </tr>
    <tr>
      <td id="T_33fd9_row24_col0" class="data row24 col0" >UNI_run of river</td>
      <td id="T_33fd9_row24_col1" class="data row24 col1" >-11277.4897</td>
    </tr>
    <tr>
      <td id="T_33fd9_row25_col0" class="data row25 col0" >UNI_storage</td>
      <td id="T_33fd9_row25_col1" class="data row25 col1" >-25932.3193</td>
    </tr>
    <tr>
      <td id="T_33fd9_row26_col0" class="data row26 col0" >SI_Industrial</td>
      <td id="T_33fd9_row26_col1" class="data row26 col1" >-36735.2423</td>
    </tr>
    <tr>
      <td id="T_33fd9_row27_col0" class="data row27 col0" >LNI_Non-industrial</td>
      <td id="T_33fd9_row27_col1" class="data row27 col1" >-44682.9931</td>
    </tr>
    <tr>
      <td id="T_33fd9_row28_col0" class="data row28 col0" >UNI_geo</td>
      <td id="T_33fd9_row28_col1" class="data row28 col1" >-53278.4151</td>
    </tr>
    <tr>
      <td id="T_33fd9_row29_col0" class="data row29 col0" >SI_Non-industrial</td>
      <td id="T_33fd9_row29_col1" class="data row29 col1" >-85156.4275</td>
    </tr>
  </tbody>
</table>

</div>

Clause 47 of the TPM states that to be considered a beneficiary (and hence have 
a cost allocation) for a BBI, they must belong to a RCG that has positive PVEMBD (NPB).

### Benefitting customers and locations

The following table shows the customers and locations that belong to the benefitting RCGs abvove.  
The output file `customers.csv` shows the corresponding table for all 
customer locations before filtering to beneficiaries.

The `load_benefit` column is obtained from [the step-load adjusted consumer PVEMBD](#step-load-adjusted-consumer-benefits) by

 - applying the [load reallocations above](#reallocation-of-load-growth-to-edbs-at-multi-customer-nodes)
    where applicable, and the IRA offtake ratio elsewhere to 
     the PV of load supplied for the different periods of binding 
  constraints and the change in load supplied (F - CF), all combined using the input
  `load_benefit_periods.csv`, as per the 
  "Calculate EMBD for each market scenario - clause 51" section of the Assumptions
  Book[^AB].
  
 - taking the weighted sum of EDGS scenarios.

*See the output file: big_load_table.csv for these intermediate values.*

The `gen_benefit` column is obtained by

 - applying the [wind repowering adjustments](#wind-repowering-adjustments-for-generator-pvembd)
  to the 
   the PV of generated energy for the different periods of binding 
  constraints and the change in energy generated (F - CF), all combined using the input
  `load_benefit_periods.csv`, as per the 
  "Calculate EMBD for each market scenario - clause 51" section of the Assumptions
  Book[^AB].
  
 - taking the weighted sum of EDGS scenarios.

*See the output file: `custloc_gen.csv` for these intermediate values.*


*Output file: bens.csv*
<div class="table-responsive container" style="max-width: 1000px; max-height: 500px; overflow: auto;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th>load_benefit</th>
      <th>gen_benefit</th>
      <th>pvembd</th>
      <th>prov_group</th>
      <th>ira</th>
      <th>final_group</th>
      <th>npb</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <th>MELT</th>
      <th>WDV</th>
      <td>-7</td>
      <td>3367</td>
      <td>3360</td>
      <td>LNI_wind</td>
      <td>252030144</td>
      <td>LNI_wind</td>
      <td>2876</td>
    </tr>
    <tr>
      <th>MELW</th>
      <th>WWD</th>
      <td>0</td>
      <td>4972</td>
      <td>4972</td>
      <td>LNI_wind</td>
      <td>499573780</td>
      <td>LNI_wind</td>
      <td>5701</td>
    </tr>
    <tr>
      <th>MSVP</th>
      <th>LTN</th>
      <td>-11</td>
      <td>7422</td>
      <td>7411</td>
      <td>LNI_wind</td>
      <td>559092523</td>
      <td>LNI_wind</td>
      <td>6381</td>
    </tr>
    <tr>
      <th>TARW</th>
      <th>TWC</th>
      <td>0</td>
      <td>4744</td>
      <td>4744</td>
      <td>LNI_wind</td>
      <td>405468001</td>
      <td>LNI_wind</td>
      <td>4627</td>
    </tr>
    <tr>
      <th>WAV1</th>
      <th>WVY</th>
      <td>-3</td>
      <td>4115</td>
      <td>4111</td>
      <td>LNI_wind</td>
      <td>439078937</td>
      <td>LNI_wind</td>
      <td>5011</td>
    </tr>
    <tr>
      <th>KIWI</th>
      <th>HWA</th>
      <td>-3</td>
      <td>1370</td>
      <td>1367</td>
      <td>LNI_cogen</td>
      <td>151013251</td>
      <td>LNI_cogen</td>
      <td>1367</td>
    </tr>
    <tr>
      <th>TRUG</th>
      <th>HWA</th>
      <td>-0</td>
      <td>691</td>
      <td>691</td>
      <td>LNI_run of river</td>
      <td>104481986</td>
      <td>LNI_run of river</td>
      <td>691</td>
    </tr>
    <tr>
      <th>CTCT</th>
      <th>SFD</th>
      <td>-43</td>
      <td>61</td>
      <td>19</td>
      <td>LNI_gen_with_load</td>
      <td>998272522</td>
      <td>LNI_gen_with_load</td>
      <td>447</td>
    </tr>
    <tr>
      <th>TBOP</th>
      <th>KPA</th>
      <td>-643</td>
      <td>909</td>
      <td>266</td>
      <td>LNI_gen_with_load</td>
      <td>99281720</td>
      <td>LNI_gen_with_load</td>
      <td>44</td>
    </tr>
    <tr>
      <th>UNET</th>
      <th>WIL</th>
      <td>-1841</td>
      <td>2091</td>
      <td>250</td>
      <td>LNI_gen_with_load</td>
      <td>96623766</td>
      <td>LNI_gen_with_load</td>
      <td>43</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">TBOP</th>
      <th>JRD</th>
      <td>0</td>
      <td>112</td>
      <td>112</td>
      <td>LNI_peaker</td>
      <td>261049468</td>
      <td>LNI_peaker</td>
      <td>58</td>
    </tr>
    <tr>
      <th>MKE</th>
      <td>0</td>
      <td>11</td>
      <td>11</td>
      <td>LNI_peaker</td>
      <td>292787165</td>
      <td>LNI_peaker</td>
      <td>65</td>
    </tr>
    <tr>
      <th>ALPE</th>
      <th>ABY</th>
      <td>-157</td>
      <td>0</td>
      <td>-157</td>
      <td>SI_storage</td>
      <td>16306438</td>
      <td>SI_storage</td>
      <td>113</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">CTCT</th>
      <th>CYD</th>
      <td>-2</td>
      <td>15817</td>
      <td>15814</td>
      <td>SI_storage</td>
      <td>2149593027</td>
      <td>SI_storage</td>
      <td>14869</td>
    </tr>
    <tr>
      <th>ROX</th>
      <td>0</td>
      <td>12144</td>
      <td>12144</td>
      <td>SI_storage</td>
      <td>1739041822</td>
      <td>SI_storage</td>
      <td>12030</td>
    </tr>
    <tr>
      <th>DUNE</th>
      <th>CYD</th>
      <td>-137</td>
      <td>0</td>
      <td>-137</td>
      <td>SI_storage</td>
      <td>48805477</td>
      <td>SI_storage</td>
      <td>338</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">GENE</th>
      <th>TKA</th>
      <td>-3</td>
      <td>1120</td>
      <td>1117</td>
      <td>SI_storage</td>
      <td>143961298</td>
      <td>SI_storage</td>
      <td>996</td>
    </tr>
    <tr>
      <th>TKB</th>
      <td>0</td>
      <td>6206</td>
      <td>6206</td>
      <td>SI_storage</td>
      <td>926286862</td>
      <td>SI_storage</td>
      <td>6407</td>
    </tr>
    <tr>
      <th rowspan="7" valign="top">MERI</th>
      <th>AVI</th>
      <td>0</td>
      <td>6664</td>
      <td>6664</td>
      <td>SI_storage</td>
      <td>1043973136</td>
      <td>SI_storage</td>
      <td>7222</td>
    </tr>
    <tr>
      <th>BEN</th>
      <td>0</td>
      <td>16582</td>
      <td>16582</td>
      <td>SI_storage</td>
      <td>2575992260</td>
      <td>SI_storage</td>
      <td>17819</td>
    </tr>
    <tr>
      <th>MAN</th>
      <td>0</td>
      <td>36348</td>
      <td>36348</td>
      <td>SI_storage</td>
      <td>4777265055</td>
      <td>SI_storage</td>
      <td>33046</td>
    </tr>
    <tr>
      <th>OHA</th>
      <td>0</td>
      <td>8298</td>
      <td>8298</td>
      <td>SI_storage</td>
      <td>1247320925</td>
      <td>SI_storage</td>
      <td>8628</td>
    </tr>
    <tr>
      <th>OHB</th>
      <td>0</td>
      <td>6927</td>
      <td>6927</td>
      <td>SI_storage</td>
      <td>1054260616</td>
      <td>SI_storage</td>
      <td>7293</td>
    </tr>
    <tr>
      <th>OHC</th>
      <td>0</td>
      <td>6927</td>
      <td>6927</td>
      <td>SI_storage</td>
      <td>1046933462</td>
      <td>SI_storage</td>
      <td>7242</td>
    </tr>
    <tr>
      <th>WTK</th>
      <td>0</td>
      <td>3361</td>
      <td>3361</td>
      <td>SI_storage</td>
      <td>540768368</td>
      <td>SI_storage</td>
      <td>3741</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">TRUG</th>
      <th>BWK</th>
      <td>0</td>
      <td>710</td>
      <td>710</td>
      <td>SI_storage</td>
      <td>107087806</td>
      <td>SI_storage</td>
      <td>741</td>
    </tr>
    <tr>
      <th>COL</th>
      <td>-1</td>
      <td>1727</td>
      <td>1726</td>
      <td>SI_storage</td>
      <td>255176551</td>
      <td>SI_storage</td>
      <td>1765</td>
    </tr>
    <tr>
      <th>WPOW</th>
      <th>KUM</th>
      <td>-40</td>
      <td>0</td>
      <td>-40</td>
      <td>SI_storage</td>
      <td>35087449</td>
      <td>SI_storage</td>
      <td>243</td>
    </tr>
    <tr>
      <th>TRUG</th>
      <th>ARG</th>
      <td>0</td>
      <td>372</td>
      <td>372</td>
      <td>SI_run of river</td>
      <td>41155173</td>
      <td>SI_run of river</td>
      <td>372</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">COUP</th>
      <th>BOB</th>
      <td>5711</td>
      <td>0</td>
      <td>5711</td>
      <td>UNI_Non-industrial</td>
      <td>450970220</td>
      <td>UNI_Non-industrial</td>
      <td>4392</td>
    </tr>
    <tr>
      <th>GLN</th>
      <td>2569</td>
      <td>0</td>
      <td>2569</td>
      <td>UNI_Non-industrial</td>
      <td>168632240</td>
      <td>UNI_Non-industrial</td>
      <td>1642</td>
    </tr>
    <tr>
      <th>CTCT</th>
      <th>WHI</th>
      <td>15</td>
      <td>2</td>
      <td>18</td>
      <td>UNI_Non-industrial</td>
      <td>1334845</td>
      <td>UNI_Non-industrial</td>
      <td>13</td>
    </tr>
    <tr>
      <th>EAST</th>
      <th>TUI</th>
      <td>2710</td>
      <td>0</td>
      <td>2710</td>
      <td>UNI_Non-industrial</td>
      <td>296362362</td>
      <td>UNI_Non-industrial</td>
      <td>2886</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">HRZE</th>
      <th>EDG</th>
      <td>1551</td>
      <td>-43</td>
      <td>1508</td>
      <td>UNI_Non-industrial</td>
      <td>88624008</td>
      <td>UNI_Non-industrial</td>
      <td>863</td>
    </tr>
    <tr>
      <th>WAI</th>
      <td>1012</td>
      <td>0</td>
      <td>1012</td>
      <td>UNI_Non-industrial</td>
      <td>60929346</td>
      <td>UNI_Non-industrial</td>
      <td>593</td>
    </tr>
    <tr>
      <th rowspan="3" valign="top">NPOW</th>
      <th>BRB</th>
      <td>1418</td>
      <td>0</td>
      <td>1418</td>
      <td>UNI_Non-industrial</td>
      <td>110508619</td>
      <td>UNI_Non-industrial</td>
      <td>1076</td>
    </tr>
    <tr>
      <th>MPE</th>
      <td>5316</td>
      <td>0</td>
      <td>5316</td>
      <td>UNI_Non-industrial</td>
      <td>592125310</td>
      <td>UNI_Non-industrial</td>
      <td>5766</td>
    </tr>
    <tr>
      <th>MTO</th>
      <td>1225</td>
      <td>0</td>
      <td>1225</td>
      <td>UNI_Non-industrial</td>
      <td>106716681</td>
      <td>UNI_Non-industrial</td>
      <td>1039</td>
    </tr>
    <tr>
      <th rowspan="13" valign="top">POCO</th>
      <th>ARI</th>
      <td>956</td>
      <td>0</td>
      <td>956</td>
      <td>UNI_Non-industrial</td>
      <td>83948525</td>
      <td>UNI_Non-industrial</td>
      <td>817</td>
    </tr>
    <tr>
      <th>HIN</th>
      <td>1085</td>
      <td>0</td>
      <td>1085</td>
      <td>UNI_Non-industrial</td>
      <td>202915666</td>
      <td>UNI_Non-industrial</td>
      <td>1976</td>
    </tr>
    <tr>
      <th>KIN</th>
      <td>4638</td>
      <td>-1365</td>
      <td>3329</td>
      <td>UNI_Non-industrial</td>
      <td>391264560</td>
      <td>UNI_Non-industrial</td>
      <td>3810</td>
    </tr>
    <tr>
      <th>KMO</th>
      <td>1253</td>
      <td>0</td>
      <td>1253</td>
      <td>UNI_Non-industrial</td>
      <td>97444722</td>
      <td>UNI_Non-industrial</td>
      <td>949</td>
    </tr>
    <tr>
      <th>KPU</th>
      <td>1883</td>
      <td>0</td>
      <td>1883</td>
      <td>UNI_Non-industrial</td>
      <td>224171551</td>
      <td>UNI_Non-industrial</td>
      <td>2183</td>
    </tr>
    <tr>
      <th>MTM</th>
      <td>2233</td>
      <td>0</td>
      <td>2233</td>
      <td>UNI_Non-industrial</td>
      <td>280356924</td>
      <td>UNI_Non-industrial</td>
      <td>2730</td>
    </tr>
    <tr>
      <th>MTR</th>
      <td>364</td>
      <td>0</td>
      <td>364</td>
      <td>UNI_Non-industrial</td>
      <td>33516454</td>
      <td>UNI_Non-industrial</td>
      <td>326</td>
    </tr>
    <tr>
      <th>OKN</th>
      <td>71</td>
      <td>0</td>
      <td>71</td>
      <td>UNI_Non-industrial</td>
      <td>8438888</td>
      <td>UNI_Non-industrial</td>
      <td>82</td>
    </tr>
    <tr>
      <th>PAO</th>
      <td>1986</td>
      <td>0</td>
      <td>1986</td>
      <td>UNI_Non-industrial</td>
      <td>201452000</td>
      <td>UNI_Non-industrial</td>
      <td>1962</td>
    </tr>
    <tr>
      <th>TGA</th>
      <td>4319</td>
      <td>-1158</td>
      <td>3161</td>
      <td>UNI_Non-industrial</td>
      <td>405052947</td>
      <td>UNI_Non-industrial</td>
      <td>3944</td>
    </tr>
    <tr>
      <th>TMI</th>
      <td>2229</td>
      <td>0</td>
      <td>2229</td>
      <td>UNI_Non-industrial</td>
      <td>232019042</td>
      <td>UNI_Non-industrial</td>
      <td>2259</td>
    </tr>
    <tr>
      <th>WHU</th>
      <td>2361</td>
      <td>0</td>
      <td>2361</td>
      <td>UNI_Non-industrial</td>
      <td>167020169</td>
      <td>UNI_Non-industrial</td>
      <td>1626</td>
    </tr>
    <tr>
      <th>WKO</th>
      <td>1417</td>
      <td>0</td>
      <td>1417</td>
      <td>UNI_Non-industrial</td>
      <td>182759152</td>
      <td>UNI_Non-industrial</td>
      <td>1780</td>
    </tr>
    <tr>
      <th rowspan="6" valign="top">UNIS</th>
      <th>FHL</th>
      <td>2636</td>
      <td>0</td>
      <td>2636</td>
      <td>UNI_Non-industrial</td>
      <td>290947233</td>
      <td>UNI_Non-industrial</td>
      <td>2833</td>
    </tr>
    <tr>
      <th>OWH</th>
      <td>524</td>
      <td>0</td>
      <td>524</td>
      <td>UNI_Non-industrial</td>
      <td>56623655</td>
      <td>UNI_Non-industrial</td>
      <td>551</td>
    </tr>
    <tr>
      <th>RDF</th>
      <td>1931</td>
      <td>0</td>
      <td>1931</td>
      <td>UNI_Non-industrial</td>
      <td>283553522</td>
      <td>UNI_Non-industrial</td>
      <td>2761</td>
    </tr>
    <tr>
      <th>ROT</th>
      <td>2929</td>
      <td>-791</td>
      <td>2138</td>
      <td>UNI_Non-industrial</td>
      <td>233401274</td>
      <td>UNI_Non-industrial</td>
      <td>2273</td>
    </tr>
    <tr>
      <th>TRK</th>
      <td>333</td>
      <td>0</td>
      <td>333</td>
      <td>UNI_Non-industrial</td>
      <td>36573785</td>
      <td>UNI_Non-industrial</td>
      <td>356</td>
    </tr>
    <tr>
      <th>WTU</th>
      <td>3731</td>
      <td>0</td>
      <td>3731</td>
      <td>UNI_Non-industrial</td>
      <td>435962199</td>
      <td>UNI_Non-industrial</td>
      <td>4245</td>
    </tr>
    <tr>
      <th rowspan="15" valign="top">VECT</th>
      <th>ALB</th>
      <td>6624</td>
      <td>0</td>
      <td>6624</td>
      <td>UNI_Non-industrial</td>
      <td>936458581</td>
      <td>UNI_Non-industrial</td>
      <td>9119</td>
    </tr>
    <tr>
      <th>HEN</th>
      <td>7331</td>
      <td>0</td>
      <td>7331</td>
      <td>UNI_Non-industrial</td>
      <td>524217649</td>
      <td>UNI_Non-industrial</td>
      <td>5105</td>
    </tr>
    <tr>
      <th>HEP</th>
      <td>5050</td>
      <td>0</td>
      <td>5050</td>
      <td>UNI_Non-industrial</td>
      <td>615248023</td>
      <td>UNI_Non-industrial</td>
      <td>5991</td>
    </tr>
    <tr>
      <th>HOB</th>
      <td>5048</td>
      <td>0</td>
      <td>5048</td>
      <td>UNI_Non-industrial</td>
      <td>256452850</td>
      <td>UNI_Non-industrial</td>
      <td>2497</td>
    </tr>
    <tr>
      <th>LFD</th>
      <td>549</td>
      <td>0</td>
      <td>549</td>
      <td>UNI_Non-industrial</td>
      <td>67338357</td>
      <td>UNI_Non-industrial</td>
      <td>656</td>
    </tr>
    <tr>
      <th>MNG</th>
      <td>8179</td>
      <td>0</td>
      <td>8179</td>
      <td>UNI_Non-industrial</td>
      <td>639468930</td>
      <td>UNI_Non-industrial</td>
      <td>6227</td>
    </tr>
    <tr>
      <th>OTA</th>
      <td>2831</td>
      <td>0</td>
      <td>2831</td>
      <td>UNI_Non-industrial</td>
      <td>302160261</td>
      <td>UNI_Non-industrial</td>
      <td>2942</td>
    </tr>
    <tr>
      <th>PAK</th>
      <td>5770</td>
      <td>0</td>
      <td>5770</td>
      <td>UNI_Non-industrial</td>
      <td>639923401</td>
      <td>UNI_Non-industrial</td>
      <td>6232</td>
    </tr>
    <tr>
      <th>PEN</th>
      <td>19092</td>
      <td>0</td>
      <td>19092</td>
      <td>UNI_Non-industrial</td>
      <td>2138725360</td>
      <td>UNI_Non-industrial</td>
      <td>20827</td>
    </tr>
    <tr>
      <th>ROS</th>
      <td>5434</td>
      <td>0</td>
      <td>5434</td>
      <td>UNI_Non-industrial</td>
      <td>683350587</td>
      <td>UNI_Non-industrial</td>
      <td>6654</td>
    </tr>
    <tr>
      <th>SVL</th>
      <td>4303</td>
      <td>0</td>
      <td>4303</td>
      <td>UNI_Non-industrial</td>
      <td>471206560</td>
      <td>UNI_Non-industrial</td>
      <td>4589</td>
    </tr>
    <tr>
      <th>TAK</th>
      <td>4098</td>
      <td>0</td>
      <td>4098</td>
      <td>UNI_Non-industrial</td>
      <td>522561458</td>
      <td>UNI_Non-industrial</td>
      <td>5089</td>
    </tr>
    <tr>
      <th>WEL</th>
      <td>1660</td>
      <td>0</td>
      <td>1660</td>
      <td>UNI_Non-industrial</td>
      <td>171754434</td>
      <td>UNI_Non-industrial</td>
      <td>1673</td>
    </tr>
    <tr>
      <th>WIR</th>
      <td>4859</td>
      <td>0</td>
      <td>4859</td>
      <td>UNI_Non-industrial</td>
      <td>475293776</td>
      <td>UNI_Non-industrial</td>
      <td>4628</td>
    </tr>
    <tr>
      <th>WRD</th>
      <td>4294</td>
      <td>0</td>
      <td>4294</td>
      <td>UNI_Non-industrial</td>
      <td>299016331</td>
      <td>UNI_Non-industrial</td>
      <td>2912</td>
    </tr>
    <tr>
      <th rowspan="2" valign="top">WAIP</th>
      <th>CBG</th>
      <td>3572</td>
      <td>0</td>
      <td>3572</td>
      <td>UNI_Non-industrial</td>
      <td>232675179</td>
      <td>UNI_Non-industrial</td>
      <td>2266</td>
    </tr>
    <tr>
      <th>TMU</th>
      <td>2770</td>
      <td>0</td>
      <td>2770</td>
      <td>UNI_Non-industrial</td>
      <td>195437859</td>
      <td>UNI_Non-industrial</td>
      <td>1903</td>
    </tr>
    <tr>
      <th rowspan="3" valign="top">WELE</th>
      <th>HAM</th>
      <td>4408</td>
      <td>0</td>
      <td>4408</td>
      <td>UNI_Non-industrial</td>
      <td>757637063</td>
      <td>UNI_Non-industrial</td>
      <td>7378</td>
    </tr>
    <tr>
      <th>HLY</th>
      <td>2397</td>
      <td>0</td>
      <td>2397</td>
      <td>UNI_Non-industrial</td>
      <td>132020946</td>
      <td>UNI_Non-industrial</td>
      <td>1286</td>
    </tr>
    <tr>
      <th>TWH</th>
      <td>4568</td>
      <td>-1738</td>
      <td>2829</td>
      <td>UNI_Non-industrial</td>
      <td>323886040</td>
      <td>UNI_Non-industrial</td>
      <td>3154</td>
    </tr>
    <tr>
      <th rowspan="5" valign="top">WTOM</th>
      <th>HTI</th>
      <td>2381</td>
      <td>0</td>
      <td>2381</td>
      <td>UNI_Non-industrial</td>
      <td>163348358</td>
      <td>UNI_Non-industrial</td>
      <td>1591</td>
    </tr>
    <tr>
      <th>NPK</th>
      <td>219</td>
      <td>0</td>
      <td>219</td>
      <td>UNI_Non-industrial</td>
      <td>16089458</td>
      <td>UNI_Non-industrial</td>
      <td>157</td>
    </tr>
    <tr>
      <th>OKN</th>
      <td>156</td>
      <td>0</td>
      <td>156</td>
      <td>UNI_Non-industrial</td>
      <td>18633410</td>
      <td>UNI_Non-industrial</td>
      <td>181</td>
    </tr>
    <tr>
      <th>ONG</th>
      <td>302</td>
      <td>0</td>
      <td>302</td>
      <td>UNI_Non-industrial</td>
      <td>16322692</td>
      <td>UNI_Non-industrial</td>
      <td>159</td>
    </tr>
    <tr>
      <th>TKU</th>
      <td>294</td>
      <td>0</td>
      <td>294</td>
      <td>UNI_Non-industrial</td>
      <td>35434435</td>
      <td>UNI_Non-industrial</td>
      <td>345</td>
    </tr>
    <tr>
      <th>NZST</th>
      <th>GLN</th>
      <td>6096</td>
      <td>-2479</td>
      <td>3739</td>
      <td>UNI_Industrial</td>
      <td>457108455</td>
      <td>UNI_Non-industrial</td>
      <td>4451</td>
    </tr>
    <tr>
      <th>PANP</th>
      <th>WHI</th>
      <td>4019</td>
      <td>0</td>
      <td>4019</td>
      <td>UNI_Industrial</td>
      <td>349487222</td>
      <td>UNI_Non-industrial</td>
      <td>3403</td>
    </tr>
    <tr>
      <th>SHPK</th>
      <th>PEN</th>
      <td>4</td>
      <td>0</td>
      <td>4</td>
      <td>UNI_Industrial</td>
      <td>460811</td>
      <td>UNI_Non-industrial</td>
      <td>4</td>
    </tr>
    <tr>
      <th rowspan="5" valign="top">TRNZ</th>
      <th>HAM</th>
      <td>12</td>
      <td>0</td>
      <td>12</td>
      <td>UNI_Industrial</td>
      <td>1553306</td>
      <td>UNI_Non-industrial</td>
      <td>15</td>
    </tr>
    <tr>
      <th>PEN</th>
      <td>130</td>
      <td>0</td>
      <td>130</td>
      <td>UNI_Industrial</td>
      <td>15983185</td>
      <td>UNI_Non-industrial</td>
      <td>156</td>
    </tr>
    <tr>
      <th>SWN</th>
      <td>197</td>
      <td>0</td>
      <td>197</td>
      <td>UNI_Industrial</td>
      <td>15856896</td>
      <td>UNI_Non-industrial</td>
      <td>154</td>
    </tr>
    <tr>
      <th>TMN</th>
      <td>62</td>
      <td>0</td>
      <td>62</td>
      <td>UNI_Industrial</td>
      <td>2034025</td>
      <td>UNI_Non-industrial</td>
      <td>20</td>
    </tr>
    <tr>
      <th>TNG</th>
      <td>18</td>
      <td>0</td>
      <td>18</td>
      <td>UNI_Industrial</td>
      <td>2077821</td>
      <td>UNI_Non-industrial</td>
      <td>20</td>
    </tr>
    <tr>
      <th>WNST</th>
      <th>TNG</th>
      <td>1960</td>
      <td>0</td>
      <td>1960</td>
      <td>UNI_Industrial</td>
      <td>223407024</td>
      <td>UNI_Non-industrial</td>
      <td>2176</td>
    </tr>
  </tbody>
</table>
</div>
<br>

### Determining final regional customer groups (FRCG)

For each Regional supply/demand group (e.g. (NI, supply), (SI, demand)):

 - the provisional customer groups (e.g. NI_wind, NI_peaker, ...) are sorted by 
 the ratio of PVEMBD to IRA, both summed over the group, from highest to lowest.
 - the first provisional group on the list (the one with the highest PVEMBD/IRA) 
 starts the first FRCG. 
 - Working down through the list, if a provisional group has a ratio higher than 
 80% of the previous provisional group, then it joins the same FRCG.

*Output file: ben_groups.csv*
<div class="container" style="max-width: 1000px;">
<table class="dataframe table table-sm table-striped table-hover">
  <thead>
    <tr style="text-align: left;">
      <th></th>
      <th></th>
      <th>prov_group</th>
      <th>npb</th>
      <th>ira</th>
      <th>future</th>
      <th>ratio</th>
      <th>final_group</th>
    </tr>
    <tr>
      <th>region</th>
      <th>demand_supply</th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td rowspan="7" valign="top">LNI</td>
      <td>supply</td>
      <td>LNI_wind</td>
      <td>24597.1318</td>
      <td>2155243384.60</td>
      <td>False</td>
      <td>11.4127</td>
      <td>LNI_wind</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>LNI_cogen</td>
      <td>1367.4954</td>
      <td>151013251.00</td>
      <td>False</td>
      <td>9.0555</td>
      <td>LNI_cogen</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>LNI_run of river</td>
      <td>691.2461</td>
      <td>104481986.20</td>
      <td>False</td>
      <td>6.6159</td>
      <td>LNI_run of river</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>LNI_solar</td>
      <td>1.7809</td>
      <td>300000.00</td>
      <td>True</td>
      <td>5.9363</td>
      <td>LNI_run of river</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>LNI_battery</td>
      <td>0.1046</td>
      <td>74000.00</td>
      <td>True</td>
      <td>1.4141</td>
      <td>LNI_battery</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>LNI_gen_with_load</td>
      <td>534.7793</td>
      <td>1194178008.20</td>
      <td>False</td>
      <td>0.4478</td>
      <td>LNI_gen_with_load</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>LNI_peaker</td>
      <td>123.2704</td>
      <td>553836633.60</td>
      <td>False</td>
      <td>0.2226</td>
      <td>LNI_peaker</td>
    </tr>
    <tr>
      <td rowspan="5" valign="top">SI</td>
      <td>supply</td>
      <td>SI_run of river</td>
      <td>371.5213</td>
      <td>41155173.20</td>
      <td>False</td>
      <td>9.0273</td>
      <td>SI_run of river</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>SI_wind</td>
      <td>5.5889</td>
      <td>730000.00</td>
      <td>True</td>
      <td>7.6560</td>
      <td>SI_run of river</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>SI_storage</td>
      <td>122491.3163</td>
      <td>17707860551.90</td>
      <td>False</td>
      <td>6.9173</td>
      <td>SI_storage</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>SI_solar</td>
      <td>1.5690</td>
      <td>270000.00</td>
      <td>True</td>
      <td>5.8112</td>
      <td>SI_storage</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>SI_battery</td>
      <td>0.0030</td>
      <td>74000.00</td>
      <td>True</td>
      <td>0.0408</td>
      <td>SI_battery</td>
    </tr>
    <tr>
      <td rowspan="3" valign="top">UNI</td>
      <td>demand</td>
      <td>UNI_Non-industrial</td>
      <td>159557.5001</td>
      <td>16358287898.42</td>
      <td>False</td>
      <td>9.7539</td>
      <td>UNI_Non-industrial</td>
    </tr>
    <tr>
      <td>demand</td>
      <td>UNI_Industrial</td>
      <td>10139.8053</td>
      <td>1067968745.60</td>
      <td>False</td>
      <td>9.4945</td>
      <td>UNI_Non-industrial</td>
    </tr>
    <tr>
      <td>supply</td>
      <td>UNI_peaker</td>
      <td>0.0375</td>
      <td>7700.00</td>
      <td>True</td>
      <td>4.8730</td>
      <td>UNI_peaker</td>
    </tr>
  </tbody>
</table>
</div>

----

## Inputs

Regions: regions_cni/final_region_buses.yaml

clause51 output directory: clause51_output_cni_2025-11-17_10-12-18_lfd_fix

sddp2tpm_data directory: sddp2tpm_data/data

Renewable projects (for wind repowering adjustments): renewProjects.csv

Weights: {'disruptive': 0.2, 'environmental': 0.2, 'global': 0.2, 'growth': 0.2, 'reference': 0.2}

Output directory: alloc51cni_20260127

----

[^step_loads]: See "Remove PVEMBD for customers or large plant that do not currently exist"
section of assumptions book[^AB]
[^similar]: if the ratio of generation to load benefit is between 0.5 and 1.5
[^NPB]: In this document the terms NPB and PVEMBD are interchangeable.
[^AB]: [Published version of the Assumptions Book](https://www.transpower.co.nz/our-work/industry/grid-pricing/assumptions-book)